/**********************************************************
 filename : GLCDscope.C
 author : fhn
 mcu : ATmega16A
 date : 16-SEP-2017
 purpose : to show ac signal on GLCD 128x64 
************************************************************/ 

#define F_CPU 16000000UL 
#define NO_OP() asm volatile("nop")
			
#include <avr/io.h>					
#include <util/delay.h>		

#include "GLCDfont.H" 


#define GLCD_DP	PORTB	
#define GLCD_CP	PORTD
#define GLCD_DR	DDRB	
#define GLCD_CR	DDRD	

#define GLCD_RS		0b10000000 		
#define GLCD_EN		0b01000000		
#define GLCD_CS1	0b00100000	
#define GLCD_CS2	0b00010000
#define ADC_MID_VAL 128  
uint8_t ADCVAL[256];
unsigned char PTRN[8]={0x01,0x03,0x07,0x0F,0x1F,0x3F,0x7F,0xFF};
unsigned char PXL[8]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};

unsigned long SMP_DLY=0;

uint8_t _SNC=0;
uint8_t _HLD=0;
//=================================================================================
void GLCD_WR ( unsigned char c)
{
	GLCD_DP = c;		
	GLCD_CP |= ( GLCD_EN);
	_delay_us(5);
	GLCD_CP &= (~GLCD_EN);
	_delay_us(5);
}
//=================================================================================
void GLCD_COM(unsigned char com)	
{
	GLCD_CP &= (~GLCD_RS);	
	GLCD_WR ( com );
}
//=================================================================================
void GLCD_DAT(unsigned char dat)	
{
	GLCD_CP |=  ( GLCD_RS);	
	GLCD_WR ( dat );
}
//=================================================================================
void GLCD_CHR(unsigned char ch)		
{
	GLCD_CP |=  ( GLCD_RS);	
	for ( int c=0; c<GLCD_FW; c++)
		GLCD_WR (font[ch-32][c]); 
	GLCD_WR ( 0 );
}
//=================================================================================
void GLCD_STR( char *str)
{
	for ( int i=0; str[i]!=0; i++)
	{
		GLCD_CHR ( str[i] );	
	}
}
//=================================================================================
void GLCD_Init()					
{
	GLCD_DR = 0xFF;
	GLCD_CR |= (GLCD_RS|GLCD_EN|GLCD_CS1|GLCD_CS2);//0xFF;
	GLCD_CP |= (GLCD_CS1|GLCD_CS2);
	_delay_ms(20);
	GLCD_COM(0x3E);			
	GLCD_COM(0x40);			
	GLCD_COM(0xB8);			
	GLCD_COM(0xC0);			
	GLCD_COM(0x3F);			
}
//=================================================================================
void GLCD_CLR()			
{
	int i,j;
	
	GLCD_CP |= (GLCD_CS1 | GLCD_CS2);
	for(i = 0; i < 8; i++)
	{
		GLCD_COM((0xB8) + i);
		for(j = 0; j < 64; j++)
		{
			GLCD_DAT(0);		
		}
	}
	GLCD_COM(0x40);				
	GLCD_COM(0xB8);				
}
//=================================================================================
void GLCD_RC ( int r, int c )
{
	if (c<10)
	{
		GLCD_CP |= ( GLCD_CS1);
		GLCD_CP &= (~GLCD_CS2);
	}
	else if (c<20)
	{
		GLCD_CP |= ( GLCD_CS2);	
		GLCD_CP &= (~GLCD_CS1);
	}
	else
		return;  
	GLCD_COM(0x40+((c%10)*6));
	GLCD_COM(0xB8+r);			

}
//=================================================================================
void GLCD_PAT ( )
{
	for ( int r=0; r<8; r++ )
	{
		GLCD_RC ( r, 0 );
		for ( int c=0; c<20; c++ )
		{
			if ( c==10 )
				GLCD_RC ( r, c );
			for ( int p=0; p<8; p++ )
				GLCD_DAT ( PTRN[p] );
		}
		
	}
	_delay_ms(2000);
}
//=================================================================================
void GLCD_WP ( int x, int y ) 
{
	if (x<64)
	{
		GLCD_CP |= ( GLCD_CS1);
		GLCD_CP &= (~GLCD_CS2);
	}
	else if (x<128)
	{
		GLCD_CP |= ( GLCD_CS2);
		GLCD_CP &= (~GLCD_CS1);
		x -= 64;
	}
	else
		return;  

	int r = y/8;
	GLCD_COM(0x40+x);	
	GLCD_COM(0xB8+r);	
	if (r==2 && (x%4)==0 )
		GLCD_DAT ( PXL[y%8] | 0b00000001); 
	else if (r==4 && (x%2)==0 )
		GLCD_DAT ( PXL[y%8] | 0b00000001); 
	else if (r==6 && (x%4)==0 )
		GLCD_DAT ( PXL[y%8] | 0b00000001); 
	else
		GLCD_DAT ( PXL[y%8]);
}
//=================================================================================
void GLCD_SV ( int pos, int val )
{
	if ( val>ADC_MID_VAL || val<=(-ADC_MID_VAL) )
		return; 

	int value = (val+ADC_MID_VAL)/4;
	GLCD_WP ( pos, 64-value );
}
//=================================================================================
void GLCD_SG ( ) 
{
	for ( int i=0; i<128; i+=2 )
	{
			GLCD_SV (i, 0);
			if ((i%4)==0)
			{
			GLCD_SV (i, ADC_MID_VAL/2);
			GLCD_SV (i, (-ADC_MID_VAL)/2);
			}
	}
}
//========================================================================================
void ADC_init ( )
{
    ADCSRA |= ( (1 << ADPS2) | (1 << ADPS1) | (1 << ADEN) ); 
	ADMUX = 0b11000000; 
	ADMUX |= (1<<ADLAR);
}
//========================================================================================
void GLCD_SI ( long val , int size)
{
	long v = val%100000;

	if ( size>5 && val>=100000)
		GLCD_CHR ( v/100000 + '0' );
	else
		GLCD_CHR ( ' ' );
	v = v%100000;

	if ( size>4 && val>=10000)
		GLCD_CHR ( v/10000 + '0' );
	else
		GLCD_CHR ( ' ' );
	v = v%10000;

	if ( size>3 && val>=1000)
		GLCD_CHR ( v/1000 + '0' );
	else
		GLCD_CHR ( ' ' );
	v = v%1000;

	if ( size>2 && val>=100)
		GLCD_CHR ( v/100 + '0' );
	else
		GLCD_CHR ( ' ' );
	v = v%100;

	if ( size>1 && val>=10 )
		GLCD_CHR ( v/10 + '0' );
	else
		GLCD_CHR ( ' ' );

	GLCD_CHR ( v%10 + '0' );

}
//========================================================================================
void GLCD_SGH ( int startno )
{
	
	long smp_r = (SMP_DLY*69)/100;
	smp_r += 70;

	GLCD_CLR();


	GLCD_RC(0,0);
	GLCD_SI ( smp_r ,6 );
	GLCD_STR (" uS"); 

	long smp_s = 1000000L/smp_r;
	GLCD_RC(0,11);
	GLCD_SI ( smp_s ,5 );
	GLCD_STR (" S/S");

	long Hz = smp_s/128;

	GLCD_RC(7,0);
	
	if ( Hz>=2 )
		GLCD_SI ( Hz ,5 );
	else
		GLCD_STR ("  =<2" ); 
	GLCD_STR (" Hz");

	if ( _SNC )
	{
		GLCD_RC ( 7,11 );
		GLCD_STR("SYNC");
	}

	GLCD_SG ( );

	for ( int i=0; i<128; i++ )
		GLCD_SV (i, ADCVAL[i+startno]-ADC_MID_VAL);
}
//========================================================================================
int R_ADC ( int channelno )
{
	ADMUX &= 0b11111000;
	ADMUX |= (channelno%7);  
    ADCSRA |= (1 << ADSC);
    while (ADCSRA & (1 << ADSC));
    return ADCH;
}
//========================================================================================
void CHK_SETG( ) 
{
	int d1, d2;
	if ((PINA & 0b10000000 )==0)
		_HLD = 1;
	else
		_HLD = 0;

	if ((PINA & 0b01000000 )==0)
		_SNC = 1;
	else
		_SNC = 0;

	R_ADC(5);
	d1= R_ADC(5);
	d2= R_ADC(5);
	SMP_DLY		 = ((d1+d2)*100);
	R_ADC(4);
	d1= R_ADC(4);
	d2= R_ADC(4);
	SMP_DLY		 += ((d1+d2)/2);
	if (SMP_DLY>51200)
		SMP_DLY = 51200;
}

//========================================================================================

int main(void)
{
	int STNO=0;
	int mxv=-600;

	MCUCSR = 0x80;
	MCUCSR = 0x80;

	_delay_ms(2000);
	
	GLCD_Init();
	DDRA = 0x00;
	DDRC = 0x0F;									
	_delay_ms(100);
	GLCD_CLR();								
	_delay_ms(10);
	GLCD_RC(0,0);
	GLCD_STR("GLCD-SCOPE");	
	GLCD_RC ( 3,0 );
	GLCD_STR("for EFY");	
	GLCD_RC ( 5,0 );
	GLCD_STR("ATmega16A");	
	GLCD_RC ( 6,0 );
	GLCD_STR("JHD12864E");	
	GLCD_RC ( 7,12 );
	GLCD_STR("fhn/..");	

	_delay_ms(2000);

	GLCD_CLR();
	GLCD_PAT ( );

	ADC_init ( );

	for ( int i=0; i<128; i++)
	{
		ADCVAL[i]= R_ADC ( 0 );
		_delay_ms(10);
	}
	GLCD_SGH ( 0 );
	_delay_ms( 100 );
	
	while(1)
	{
		CHK_SETG( ); 
		if ( _HLD )
		{
			GLCD_RC ( 7,16 );
			GLCD_STR("HOLD");	
			_delay_ms(1000);
			continue;
		}


		for ( int x=0; x<256; x++)
		{
			PORTC = 0x07;
			ADCVAL[x] = R_ADC ( 0 );
			PORTC = 0xFE;
			for ( long d=0; d<SMP_DLY; d++)
			{ 
				NO_OP(); 
			}
				
		}
		PORTC = 0x0C;
		STNO=0;
		
		if ( _SNC )
		{
			mxv=-600;
			for ( int i=0; i<128; i++)
			{
				if (ADCVAL[i]>mxv)
				{
					mxv = ADCVAL[i];
					STNO = i;
				}
			}
		}
		
		GLCD_SGH ( STNO );
		PORTC = 0x08;
		_delay_ms( 100 );
				
	}

	
	return 0;
}

//=================================================================================

